<div align="center">
    <h1>Doctrine HTTP Filter</h1>
</div>

Doctrine HTTP Filter – это PHP-библиотека для создания запросов в Doctrine с учётом параметров выборки,
полученных из Symfony Request.

## Требования
- PHP 8.3+
- Doctrine ORM 3.3+
- Symfony Http Foundation 7.2+

## Использование

### Настройка репозиториев Doctrine ORM

Для использования библиотеки необходимо унаследовать репозиторий от `HttpFilterEntityRepository`.

```php
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Mapping\ClassMetadata;
use IQDEV\Packages\DoctrineHttpFilter\HttpFilterEntityRepository;
use App\Entity\Post;

class PostRepository extends HttpFilterEntityRepository
{
    public function __construct(EntityManagerInterface $em)
    {
        parent::__construct($em, new ClassMetadata(Post::class));
    }

    public function getAliasTableForFilter(): string
    {
        return 'p';
    }
}
```

После этого в репозитории станет доступен метод `createQueryByFilter`, который принимает набор фильтров и, при необходимости, объект `Request`.

### Пример фильтрации

Для фильтрации **используется query-параметр filters из Request**.

Набор фильтров представляет собой массив, где ключ – это поле для фильтрации, а значение – тип фильтра.

Ключ фильтрации соответствует ключу из `Request` и, в случае стандартных фильтров, колонке фильтруемой сущности.

```php
use IQDEV\Packages\DoctrineHttpFilter\Filter\Where;
use Symfony\Component\HttpFoundation\Request;

$filters = [
    'title' => Where::class,
];

// Этот параметр необязательный. В случае null будет собран из Request::createFromGlobals();
$request = new Request([ 'filters' => [ 'title' => 'Example' ]]);

$posts = $postRepository
    ->createQueryByFilter($filters, $request)
    ->getQuery()
    ->getResult();
```

## Roadmap

- [x] Добавить базовые интерфейсы/классы для работы с фильтрацией
- [ ] Добавить базовые фильтры:
  - [x] Where
  - [ ] Like
  - [ ] ILike
  - [ ] Range
  - [ ] In
  - [ ] Date
  - [ ] DateRange
- [ ] Добавить возможность сортировки
- [ ] Добавить поддержку вендорных и других кастомных реализаций EntityManager вместе с HttpFilterEntityRepository