<?php

use PhpCsFixer\Config;
use PhpCsFixer\Finder;

$finder = Finder::create()
    ->in([
        __DIR__ . '/src',
        __DIR__ . '/tests',
    ])
    ->name('*.php');

$rules = [
    '@PER-CS2.0' => true,
    'binary_operator_spaces' => ['default' => 'single_space'],
    'no_unused_imports' => true,
    'single_quote' => true,
    'trailing_comma_in_multiline' => ['elements' => ['arrays', 'arguments', 'parameters']],
];

return (new Config())
    ->setFinder($finder)
    ->setRules($rules)
    ->setRiskyAllowed(false)
    ->setUsingCache(true)
    ->setCacheFile('./var/cache/.php-cs-fixer.cache');
