<?php

declare(strict_types=1);

namespace IQDEV\Packages\DoctrineHttpFilter;

use Doctrine\ORM\QueryBuilder;
use Symfony\Component\HttpFoundation\Request;

abstract class HttpFilter
{
    public const string REQUEST_FILTER_KEY = 'filters';

    protected Request $request;

    public function __construct(
        protected string $tableAlias,
        protected string $filed,
        ?Request $request = null,
    ) {
        $this->request = $request ?? Request::createFromGlobals();
    }

    protected function getColumn(): string
    {
        return $this->tableAlias . '.' . $this->filed;
    }

    protected function getHttpValue(): mixed
    {
        $filter = $this
            ->request
            ->query
            ->getIterator()[static::REQUEST_FILTER_KEY] ?? null;

        if ($filter === null) {
            return null;
        }

        return $filter[$this->filed] ?? null;
    }

    public function getParameterKey(): string
    {
        return str_replace('.', '_', $this->getColumn());
    }

    abstract public function addToQuery(QueryBuilder $queryBuilder): QueryBuilder;
}
