<?php

declare(strict_types=1);

namespace IQDEV\Packages\DoctrineHttpFilter\Filter;

use Doctrine\ORM\QueryBuilder;
use IQDEV\Packages\DoctrineHttpFilter\HttpFilter;

final class DateRange extends HttpFilter
{
    public function addToQuery(QueryBuilder $queryBuilder): QueryBuilder
    {
        $httpValues = $this->getHttpValue();
        $fromDate = $httpValues['from'] ?? null;
        $toDate = $httpValues['to'] ?? null;

        if (is_null($fromDate) && is_null($toDate)) {
            return $queryBuilder;
        }

        $fromDate = \DateTimeImmutable::createFromFormat('Y-m-d', $fromDate ?? '');
        $toDate = \DateTimeImmutable::createFromFormat('Y-m-d', $toDate ?? '');

        if (! $fromDate && ! $toDate) {
            return $queryBuilder;
        }

        if ($fromDate) {
            $queryBuilder->where($this->getColumn() . ' >= :fromDate')
                ->setParameter('fromDate', $fromDate->setTime(0, 0, 0));
        }

        if ($toDate) {
            $queryBuilder->andWhere($this->getColumn() . ' <= :toDate')
                ->setParameter('toDate', $toDate->setTime(23, 59, 59));
        }

        return $queryBuilder;
    }
}
