<?php

declare(strict_types=1);

namespace IQDEV\Tests\Packages\DoctrineHttpFilter\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use IQDEV\Tests\Packages\DoctrineHttpFilter\Repository\PostRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: PostRepository::class)]
class Post
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: 'integer')]
    public ?int $id = null;

    #[ORM\Column(type: 'string', length: 255)]
    public ?string $title = null;

    #[ORM\Column(type: 'text')]
    public ?string $content = null;

    #[ORM\Column(type: 'boolean', options: ['default' => false])]
    public ?bool $moderated = null;

    #[ORM\Column(name: 'created_at', type: 'datetime_immutable')]
    public ?\DateTimeImmutable $createdAt = null;

    #[ORM\Column(name: 'updated_at', type: 'datetime_immutable', nullable: true)]
    public ?\DateTimeImmutable $updatedAt = null;

    #[ORM\Column(type: 'integer', nullable: true)]
    public ?int $countOfViews = null;

    #[ORM\OneToMany(targetEntity: Comment::class, mappedBy: 'post')]
    public Collection $comments;

    public function __construct(
        string $title,
        ?string $content,
        ?bool $moderated,
        ?\DateTimeImmutable $createdAt,
        ?\DateTimeImmutable $updatedAt = null,
        ?int $countOfViews = null
    ) {
        $this->title = $title;
        $this->content = $content;
        $this->moderated = $moderated;
        $this->createdAt = $createdAt;
        $this->updatedAt = $updatedAt;
        $this->countOfViews = $countOfViews;

        $this->comments = new ArrayCollection();
    }
}
