<?php

declare(strict_types=1);

namespace IQDEV\Tests\Packages\DoctrineHttpFilter\Entity;

use Doctrine\ORM\Mapping as ORM;
use IQDEV\Tests\Packages\DoctrineHttpFilter\Repository\CommentRepository;

#[ORM\Entity(repositoryClass: CommentRepository::class)]
class Comment
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: 'integer')]
    public ?int $id = null;

    #[ORM\Column(type: 'string', length: 255)]
    public ?string $author = null;

    #[ORM\Column(type: 'text')]
    public ?string $content = null;

    #[ORM\Column(name: 'created_at', type: 'datetime_immutable')]
    public ?\DateTimeImmutable $createdAt = null;

    #[ORM\Column(name: 'updated_at', type: 'datetime_immutable', nullable: true)]
    public ?\DateTimeImmutable $updatedAt = null;

    #[ORM\ManyToOne(inversedBy: 'comments')]
    public ?Post $post = null;

    public function __construct(
        string $author,
        string $content,
        \DateTimeImmutable $createdAt,
        Post $post,
        ?\DateTimeImmutable $updatedAt = null,
    ) {
        $this->author = $author;
        $this->content = $content;
        $this->createdAt = $createdAt;
        $this->updatedAt = $updatedAt;
        $this->post = $post;
    }
}
