<?php

declare(strict_types=1);

namespace IQDEV\Packages\DoctrineHttpFilter\Filter;

use Doctrine\ORM\QueryBuilder;
use IQDEV\Packages\DoctrineHttpFilter\Exception\FilterParameterValueIsNullException;
use IQDEV\Packages\DoctrineHttpFilter\HttpFilter;

final class Where extends HttpFilter
{
    /** @throws FilterParameterValueIsNullException */
    public function addToQuery(QueryBuilder $queryBuilder): QueryBuilder
    {
        $queryBuilder->where(
            $this->getColumn() . ' = :' . $this->getParameterKey(),
        );

        if ($this->getHttpValue() === null) {
            throw new FilterParameterValueIsNullException($this->field);
        }

        $queryBuilder->setParameter($this->getParameterKey(), $this->getHttpValue());

        return $queryBuilder;
    }
}
