<?php

declare(strict_types=1);

namespace IQDEV\Packages\DoctrineHttpFilter\Filter;

use Doctrine\ORM\QueryBuilder;
use IQDEV\Packages\DoctrineHttpFilter\HttpFilter;

final class Range extends HttpFilter
{
    public function addToQuery(QueryBuilder $queryBuilder): QueryBuilder
    {
        $queryBuilder->where(
            $this->getColumn() . '>= ' . $this->getHttpValue()['min'] . ' AND ' .
            $this->getColumn() . ' <= ' . $this->getHttpValue()['max'],
        );

        return $queryBuilder;
    }
}
