<?php

declare(strict_types=1);

namespace IQDEV\Packages\DoctrineHttpFilter\Filter;

use Doctrine\ORM\QueryBuilder;
use IQDEV\Packages\DoctrineHttpFilter\HttpFilter;

final class DateRange extends HttpFilter
{
    public function addToQuery(QueryBuilder $queryBuilder): QueryBuilder
    {
        $queryBuilder->where(
            'strftime(\'%Y-%m-%d\', ' . $this->getColumn() . ') >= \'' . $this->getHttpValue()['from'] . '\' AND ' .
                   'strftime(\'%Y-%m-%d\', ' . $this->getColumn() . ') <= \'' . $this->getHttpValue()['to'] . '\'',
        );

        return $queryBuilder;
    }
}
