<?php

namespace App\Service\Response\Classes;

use App\Service\Dto\Classes\TokenDto;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Serializer\Annotation\Groups;

#[AsAlias(id: 'response.token', public: true)]
class TokenResponse extends Response
{
    /**
     * @var TokenDto
     */
    #[Groups(["data"])]
    public TokenDto $data;

    public function setToken(string $token): void
    {
        if (!isset($this->data)) {
            $this->data = new TokenDto();
        }
        $this->data->token = $token;
    }

    public function setRefreshToken(string $token): void
    {
        if (!isset($this->data)) {
            $this->data = new TokenDto();
        }
        $this->data->refreshToken = $token;
    }
}