<?php

namespace App\Service\Response\Classes\Data;

use App\Entity\Genre;
use App\Entity\Tag;
use App\Entity\Theme;
use App\Repository\QuestRepository;
use Symfony\Component\Serializer\Annotation\Groups;

class Filter
{
    /**
     * @var Tag[]
     */
    #[Groups(['filter'])]
    public array $tags;

    /**
     * @var Genre[]
     */
    #[Groups(['filter'])]
    public array $genres;

    /**
     * @var Theme[]
     */
    #[Groups(['filter'])]
    public array $themes;

    /**
     * @var string[]
     */
    #[Groups(['filter'])]
    public array $sortFields = QuestRepository::SORT_FIELDS;

    /**
     * @var string[]
     */
    #[Groups(['filter'])]
    public array $sorts = QuestRepository::SORT_TYPES;
}