<?php

namespace App\Service\Action\Classes;

use App\Entity\Quest;
use App\Service\Action\UserBaseActionService;
use App\Service\Dto\Classes\PageDto;
use App\Service\Dto\DtoServiceInterface;
use App\Service\Response\ResponseServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.quests', public: true)]
class GetQuests extends UserBaseActionService
{
    #[Required] public function initResponse(
        #[Autowire(service: 'response.quests.page')]
        ResponseServiceInterface $responseService
    ): void
    {
        parent::initResponse($responseService);
    }

    #[Required] public function initDto(
        #[Autowire(service: 'dto.page')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }

    public function runAction(): void
    {
        /** @var PageDto $dto */
        $dto = $this->getDto();
        if ($userId = $this->user->getId()) {
            if ($dto) {
                $this->responseService->setData($this->doctrine->getRepository(Quest::class)->findAllByFilterPaged($userId, $dto->page, $dto->limit));
            } else {
                $this->responseService->setData($this->doctrine->getRepository(Quest::class)->findAllByFilterPaged($userId));
            }
        } else {
            $this->responseService->addError('Пользователь не сохранен');
        }
    }

    public function needDto(): bool
    {
        return false;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return false;
    }
}