<?php

namespace App\Service\Action\Classes;

use App\Entity\Quest;
use App\Service\Action\UserBaseActionService;
use App\Service\Response\ResponseServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.profile.quests', public: true)]
class GetProfileQuests extends UserBaseActionService
{
    #[Required] public function initResponse(
        #[Autowire(service: 'response.quests')]
        ResponseServiceInterface $responseService
    ): void
    {
        parent::initResponse($responseService);
    }

    public function runAction(): void
    {
        if ($userId = $this->user->getId()) {
            $this->responseService->setData($this->doctrine->getRepository(Quest::class)->findCompletedByFilter($userId));
        } else {
            $this->responseService->addError('Пользователь не сохранен');
        }
    }

    public function needDto(): bool
    {
        return false;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return false;
    }
}