<?php

namespace App\Repository;

use App\Entity\User;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\Security\Core\Exception\UnsupportedUserException;
use Symfony\Component\Security\Core\User\PasswordAuthenticatedUserInterface;
use Symfony\Component\Security\Core\User\PasswordUpgraderInterface;

/**
 * @extends ServiceEntityRepository<User>
 */
class UserRepository extends ServiceEntityRepository implements PasswordUpgraderInterface
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, User::class);
    }

    /**
     * Used to upgrade (rehash) the user's password automatically over time.
     */
    public function upgradePassword(PasswordAuthenticatedUserInterface $user, string $newHashedPassword): void
    {
        if (!$user instanceof User) {
            throw new UnsupportedUserException(sprintf('Instances of "%s" are not supported.', $user::class));
        }

        $user->setPassword($newHashedPassword);
        $this->getEntityManager()->persist($user);
        $this->getEntityManager()->flush();
    }

    /**
     * Поиск пользователя по Email или номеру телефона
     *
     * @param string|null $sEmail
     * @param string|null $sPhone
     * @param int|null $iIgnoreId
     *
     * @return User|null
     */
    public function findOneByUniq(?string $sEmail = null, ?string $sPhone = null, ?int $iIgnoreId = null): ?User
    {
        $oQuery = $this->createQueryBuilder('u');
        if (!empty($sEmail)) {
            $oQuery->orWhere('u.email = :email')->setParameter('email', $sEmail);
        }
        if (!empty($sPhone)) {
            $oQuery->orWhere('u.phone_number = :phone_number')->setParameter('phone_number', $sPhone);
        }
        if (!empty($iIgnoreId)) {
            $oQuery->andWhere('u.id != :id')->setParameter('id', $iIgnoreId);
        }
        return $oQuery
            ->getQuery()
            ->getOneOrNullResult();
    }

    public function getById(int $id): ?User
    {
        $oQuery = $this->createQueryBuilder('u');
        $oQuery->andWhere('u.id = :id')->setParameter('id', $id);
        return $oQuery->getQuery()->getOneOrNullResult();
    }

    //    /**
    //     * @return User[] Returns an array of User objects
    //     */
    //    public function findByExampleField($value): array
    //    {
    //        return $this->createQueryBuilder('u')
    //            ->andWhere('u.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->orderBy('u.id', 'ASC')
    //            ->setMaxResults(10)
    //            ->getQuery()
    //            ->getResult()
    //        ;
    //    }

    //    public function findOneBySomeField($value): ?User
    //    {
    //        return $this->createQueryBuilder('u')
    //            ->andWhere('u.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->getQuery()
    //            ->getOneOrNullResult()
    //        ;
    //    }
}
