<?php

namespace App\Redis;

use App\Service\Dto\DtoServiceInterface;

class RedisFilter
{
    private int $userId;
    private Redis $redis;

    public function __construct(int $userId)
    {
        $this->userId = $userId;
        $this->redis = Redis::getInstance();
    }

    public function get(): ?DtoServiceInterface
    {
        $filter = $this->redis->get($this->getCode());

        if ($filter instanceof DtoServiceInterface) {
            return $filter;
        }

        return null;
    }

    public function set(DtoServiceInterface $filterDto): void
    {
        $this->redis->set($this->getCode(), $filterDto);
    }

    private function getCode(): string
    {
        return 'filter_' . $this->userId;
    }
}