<?php

namespace App\Listeners;

use App\Service\Response\Classes\Response;
use Gesdinet\JWTRefreshTokenBundle\Event\RefreshAuthenticationFailureEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class AuthenticationFailure implements EventSubscriberInterface
{

    public static function getSubscribedEvents()
    {
        return [
            'gesdinet.refresh_token_failure' => 'failureRefresh'
        ];
    }

    /**
     * Ошибка refresh токена
     *
     * @param RefreshAuthenticationFailureEvent $event
     *
     * @return void
     * @throws \JsonException
     */
    public function failureRefresh(RefreshAuthenticationFailureEvent $event): void
    {
        $responseDto = new Response();
        $responseDto->addError('Refresh токен не валиден');

        $response = $event->getResponse();

        $response->setContent($responseDto->getResponse()->getContent());
    }
}