<?php

namespace App\Entity;

use App\Repository\QuestImageRepository;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

#[ORM\Entity(repositoryClass: QuestImageRepository::class)]
class QuestImage
{
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'SEQUENCE')]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'gallery')]
    private ?Quest $quest = null;

    #[ORM\Column(length: 255)]
    private ?string $path = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\Column(length: 255)]
    private ?string $type = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getQuest(): ?Quest
    {
        return $this->quest;
    }

    public function setQuest(?Quest $quest): static
    {
        $this->quest = $quest;

        return $this;
    }

    public function getPath(): ?string
    {
        return $this->path;
    }

    #[Groups(['all', 'card', 'detail', 'profile'])]
    public function getPublicPath(): ?string
    {
        if ($this->path !== null) {
            return str_replace('/app/public', '', $this->path);
        }
        return null;
    }

    public function setPath(string $path): static
    {
        $this->path = $path;

        return $this;
    }

    #[Groups(['all', 'card', 'detail', 'profile'])]
    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(string $type): static
    {
        $this->type = $type;

        return $this;
    }
}
