<?php

namespace App\DataFixtures;

use App\Entity\Tag;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Bundle\FixturesBundle\FixtureGroupInterface;
use Doctrine\Persistence\ObjectManager;

class TagsFixture extends Fixture implements FixtureGroupInterface
{
    public function load(ObjectManager $manager): void
    {
        $data = [
            'Новое',
            'Популярное',
            'Для семьи',
            'Детское'
        ];

        foreach ($data as $value) {
            $tag = new Tag();
            $tag->setName($value);
            $tag->setDate(new \DateTime());
            $manager->persist($tag);
        }

        $manager->flush();
    }

    public static function getGroups(): array
    {
        return ['main', 'test'];
    }
}
