<?php

namespace App\Tests;

use ApiPlatform\Symfony\Bundle\Test\ApiTestCase;
use App\Messenger\Message\SendMessage;
use Symfony\Component\Mime\Email;
use Zenstruck\Messenger\Test\InteractsWithMessenger;

class RegisterTest extends ApiTestCase
{
    use InteractsWithMessenger;

    private const EMAIL = 'ilyavasilenko26@gmail.com';
    private const PASSWORD = 'PoiLkjMnb987';

    private static ?string $token = null;
    private static ?string $code = null;

    public function testUser(): void
    {
        $this->register();
        $this->login();
        $this->confirm();
    }

    private function register(): void
    {
        $request = [
            'email' => self::EMAIL,
            'password' => self::PASSWORD,
            'repeat_password' => self::PASSWORD,
            'name' => 'Тест',
            'surname' => 'Тестов',
            'patronymic' => 'Тестович',
            'phone_number' => '8 (234) 234 23 45'
        ];

        static::createClient()->request('POST', '/api/register', [
            'headers' => ['Content-Type' => 'application/json'],
            'json' => $request
        ]);

        self::assertResponseStatusCodeSame(200);

        self::assertResponseIsSuccessful();

        $queue = $this->transport('send_transport')->queue();
        $queue->assertContains(SendMessage::class);

        $message = $queue->first(SendMessage::class)->getMessage();

        $mail = new Email();
        $mail
            ->subject($message->getSubject())
            ->from($message->getFrom())
            ->to($message->getTo())
            ->html($message->getBody());

        self::assertEmailHeaderSame($mail, 'subject', 'Подтвердите регистрацию');

        $matches = [];
        if (preg_match('/<span id="code">(\d+)<\/span>/', $message->getBody(), $matches)) {
            if (isset($matches[1])) {
                self::$code = $matches[1];
            }
        } else {
            self::fail('Код не найден в email');
        }
    }

    private function login(): void
    {
        $response = static::createClient()->request('POST', '/api/login', [
            'headers' => ['Content-Type' => 'application/json'],
            'json' => [
                'email' => self::EMAIL,
                'password' => self::PASSWORD
            ],
        ]);

        self::assertResponseStatusCodeSame(200);

        self::assertArrayHasKey('token', $response->toArray()['data']);

        self::$token = $response->toArray()['data']['token'];

        self::assertResponseIsSuccessful();
    }

    private function confirm(): void
    {
        $request = [
            'code' => self::$code
        ];

        static::createClient()->request('POST', '/api/email/check', [
            'headers' => [
                'Content-Type' => 'application/json',
                'Authorization' => 'Bearer ' . self::$token
            ],
            'json' => $request
        ]);

        self::assertResponseStatusCodeSame(200);

        self::assertResponseIsSuccessful();
    }
}
