<?php

namespace App\Service\Response\Classes;

use App\Entity\Favorite;
use App\Service\Response\Classes\Data\Filter;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Serializer\Annotation\Groups;

#[AsAlias(id: 'response.filter.params', public: true)]
class FilterParamsResponse extends Response
{
    /**
     * @var Filter
     */
    #[Groups(["data"])]
    public Filter $data;

    public function setData(Filter $filter)
    {
        $this->data = $filter;
    }

    public function getGroups(): array
    {
        return ['filter'];
    }
}