<?php

namespace App\Service\Dto\Classes;

use App\Service\Dto\BaseDto;
use Doctrine\Common\Collections\Criteria;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Serializer\Annotation\Groups;

#[AsAlias(id: 'dto.filter', public: true)]
class FilterDto extends BaseDto
{
    public const SORT_TYPES = [
        'По возрастанию' => 'ASC',
        'По убыванию' => 'DESC'
    ];
    public const SORT_FIELDS = [
        'Название' => 'name',
        'Дата проведения' => 'date',
        'Дата финальной записи' => 'final_date'
    ];

    /**
     * @var string|null
     */
    #[Groups(['data'])]
    public ?string $search;

    /**
     * @var string|null
     */
    #[Groups(['data'])]
    public ?string $sortField;

    /**
     * @var string|null
     */
    #[Groups(['data'])]
    public ?string $sort;

    /**
     * @var string[]
     */
    #[Groups(['data'])]
    public array $tags;

    /**
     * @var string[]
     */
    #[Groups(['data'])]
    public array $genres;

    /**
     * @var string[]
     */
    #[Groups(['data'])]
    public array $themes;

    /**
     * Получение фильтра ORM
     *
     * @return Criteria
     */
    public function getCriteria(): Criteria
    {
        $criteria = Criteria::create();
        $expr = Criteria::expr();

        if (!$expr) {
            return $criteria;
        }

        if (!empty($this->search)) {
            $text = $this->search;
            $criteria->orWhere($expr->contains('name', $text))
            ->orWhere($expr->contains('short_description', $text))
            ->orWhere($expr->contains('full_description', $text));
        }
        if ($genres = $this->genres) {
            $criteria->andWhere($expr->in('genre.name', $genres));
        }
        if ($themes = $this->themes) {
            $criteria->andWhere($expr->in('theme.name', $themes));
        }
        if ($tags = $this->tags) {
            $criteria->andWhere($expr->in('tags.name', $tags));
        }
        if ($this->sort
            && $this->sortField
            && in_array($this->sort, self::SORT_TYPES, true)
            && in_array($this->sortField, self::SORT_FIELDS, true)
        ) {
            $criteria->orderBy([$this->sortField => $this->sort]);
        }

        return $criteria;
    }
}