<?php

namespace App\Service\Action\Classes;

use App\Entity\Quest;
use App\Service\Action\UserBaseActionService;
use App\Service\Dto\Classes\IdDto;
use App\Service\Dto\DtoServiceInterface;
use App\Service\Response\ResponseServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.quest', public: true)]
class GetQuest extends UserBaseActionService
{
    #[Required] public function initResponse(
        #[Autowire(service: 'response.quest')]
        ResponseServiceInterface $responseService
    ): void
    {
        parent::initResponse($responseService);
    }

    #[Required] public function initDto(
        #[Autowire(service: 'dto.id')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }

    public function runAction(): void
    {
        /** @var IdDto $dto */
        $dto = $this->getDto();

        if ($dto->id && $this->user->getId()) {
            $quest = $this->doctrine->getRepository(Quest::class)->findOneById($dto->id, $this->user->getId());
            if ($quest) {
                $this->responseService->setData($quest);
            } else {
                $this->responseService->addError('Квест не найден');
            }
        } else {
            $this->responseService->addError('Не получен Id');
        }
    }

    public function needDto(): bool
    {
        return true;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return false;
    }
}