<?php

namespace App\Service\Action;

use App\Service\Dto\DtoServiceInterface;
use App\Service\Response\Classes\Response;
use App\Service\Response\ResponseServiceInterface;
use App\Service\Send\SendServiceInterface;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Contracts\Service\Attribute\Required;

abstract class BaseActionService implements ActionServiceInterface
{
    protected ?ResponseServiceInterface $responseService;

    protected ?DtoServiceInterface $dtoService;

    protected ?ManagerRegistry $doctrine;

    protected ?SendServiceInterface $sendService;

    #[Required]
    public function initResponse(
        ResponseServiceInterface $responseService
    ): void
    {
        $this->responseService = $responseService;
    }

    #[Required]
    public function initDto(
        DtoServiceInterface $dtoService
    ): void
    {
        $this->dtoService = $dtoService;
    }

    #[Required]
    public function initDoctrine(ManagerRegistry $doctrine): void
    {
        $this->doctrine = $doctrine;
    }

    #[Required]
    public function initSend(SendServiceInterface $sendService): void
    {
        $this->sendService = $sendService;
    }

    abstract public function needDto(): bool;

    public function getResponse(): JsonResponse
    {
        if ($this->validate()) {
            $this->runAction();
        }

        if ($this->responseService) {
            return $this->responseService->getResponse();
        }

        $response = new Response();
        $response->addError('Ошибка получения ответа');
        return $response->getResponse();
    }

    protected function getDto(): ?DtoServiceInterface
    {
        if ($this->dtoService) {
            return $this->dtoService->getClass();
        }

        return null;
    }

    public function validate(): bool
    {
        $valid = true;

        if ($this->needDto() && $this->dtoService) {
            $valid = $this->dtoService->validate($this->responseService);
        }

        if ($valid) {
            $valid = $this->customValidate();
        }

        return $valid;
    }

    public function customValidate(): bool
    {
        return true;
    }
}