<?php

namespace App\DataFixtures;

use App\Entity\Genre;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Bundle\FixturesBundle\FixtureGroupInterface;
use Doctrine\Persistence\ObjectManager;

class GenreFixture extends Fixture implements FixtureGroupInterface
{
    public function load(ObjectManager $manager): void
    {
        $data = [
            'Классический',
            'Квест в реальности',
            'Перфоманс',
            'Экшн',
            'Морфеус',
            'Хоррор'
        ];

        foreach ($data as $value) {
            $genre = new Genre();
            $genre->setName($value);
            $genre->setDate(new \DateTime());
            $manager->persist($genre);
        }

        $manager->flush();
    }

    public static function getGroups(): array
    {
        return ['main', 'test'];
    }
}
