<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20240624095415 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE SEQUENCE appointment_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE favorite_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE "like_id_seq" INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE quest_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE quest_image_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE review_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE TABLE appointment (id INT NOT NULL, related_user_id INT NOT NULL, quest_id INT DEFAULT NULL, date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_FE38F84498771930 ON appointment (related_user_id)');
        $this->addSql('CREATE INDEX IDX_FE38F844209E9EF4 ON appointment (quest_id)');
        $this->addSql('CREATE TABLE favorite (id INT NOT NULL, related_user_id INT NOT NULL, quest_id INT NOT NULL, date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_68C58ED998771930 ON favorite (related_user_id)');
        $this->addSql('CREATE INDEX IDX_68C58ED9209E9EF4 ON favorite (quest_id)');
        $this->addSql('CREATE TABLE "like" (id INT NOT NULL, review_id INT NOT NULL, related_user_id INT NOT NULL, date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_AC6340B33E2E969B ON "like" (review_id)');
        $this->addSql('CREATE INDEX IDX_AC6340B398771930 ON "like" (related_user_id)');
        $this->addSql('CREATE TABLE quest (id INT NOT NULL, name VARCHAR(255) NOT NULL, short_description TEXT NOT NULL, full_description TEXT DEFAULT NULL, date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, final_date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, max_appointments INT DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE quest_image (id INT NOT NULL, quest_id INT DEFAULT NULL, path VARCHAR(255) NOT NULL, name VARCHAR(255) NOT NULL, type VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_96809DC3209E9EF4 ON quest_image (quest_id)');
        $this->addSql('CREATE TABLE review (id INT NOT NULL, related_user_id INT NOT NULL, quest_id INT NOT NULL, text TEXT DEFAULT NULL, rating INT NOT NULL, create_date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_794381C698771930 ON review (related_user_id)');
        $this->addSql('CREATE INDEX IDX_794381C6209E9EF4 ON review (quest_id)');
        $this->addSql('ALTER TABLE appointment ADD CONSTRAINT FK_FE38F84498771930 FOREIGN KEY (related_user_id) REFERENCES "user" (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE appointment ADD CONSTRAINT FK_FE38F844209E9EF4 FOREIGN KEY (quest_id) REFERENCES quest (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE favorite ADD CONSTRAINT FK_68C58ED998771930 FOREIGN KEY (related_user_id) REFERENCES "user" (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE favorite ADD CONSTRAINT FK_68C58ED9209E9EF4 FOREIGN KEY (quest_id) REFERENCES quest (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE "like" ADD CONSTRAINT FK_AC6340B33E2E969B FOREIGN KEY (review_id) REFERENCES review (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE "like" ADD CONSTRAINT FK_AC6340B398771930 FOREIGN KEY (related_user_id) REFERENCES "user" (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE quest_image ADD CONSTRAINT FK_96809DC3209E9EF4 FOREIGN KEY (quest_id) REFERENCES quest (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE review ADD CONSTRAINT FK_794381C698771930 FOREIGN KEY (related_user_id) REFERENCES "user" (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE review ADD CONSTRAINT FK_794381C6209E9EF4 FOREIGN KEY (quest_id) REFERENCES quest (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE SCHEMA public');
        $this->addSql('DROP SEQUENCE appointment_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE favorite_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE "like_id_seq" CASCADE');
        $this->addSql('DROP SEQUENCE quest_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE quest_image_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE review_id_seq CASCADE');
        $this->addSql('ALTER TABLE appointment DROP CONSTRAINT FK_FE38F84498771930');
        $this->addSql('ALTER TABLE appointment DROP CONSTRAINT FK_FE38F844209E9EF4');
        $this->addSql('ALTER TABLE favorite DROP CONSTRAINT FK_68C58ED998771930');
        $this->addSql('ALTER TABLE favorite DROP CONSTRAINT FK_68C58ED9209E9EF4');
        $this->addSql('ALTER TABLE "like" DROP CONSTRAINT FK_AC6340B33E2E969B');
        $this->addSql('ALTER TABLE "like" DROP CONSTRAINT FK_AC6340B398771930');
        $this->addSql('ALTER TABLE quest_image DROP CONSTRAINT FK_96809DC3209E9EF4');
        $this->addSql('ALTER TABLE review DROP CONSTRAINT FK_794381C698771930');
        $this->addSql('ALTER TABLE review DROP CONSTRAINT FK_794381C6209E9EF4');
        $this->addSql('DROP TABLE appointment');
        $this->addSql('DROP TABLE favorite');
        $this->addSql('DROP TABLE "like"');
        $this->addSql('DROP TABLE quest');
        $this->addSql('DROP TABLE quest_image');
        $this->addSql('DROP TABLE review');
    }
}
