<?php

namespace App\Validators;

use Symfony\Component\Validator\Context\ExecutionContextInterface;

class PasswordValidator
{
    /**
     * Проверка на несовпадение нового пароля и его повтора
     *
     * @param mixed $value
     * @param ExecutionContextInterface $context
     * @param mixed $payload
     *
     * @return void
     */
    public static function validateRepeatPassword(mixed $value, ExecutionContextInterface $context, mixed $payload): void
    {
        $object = $context->getObject();
        if ($object) {
            if ($object->password !== $object->repeatPassword) {
                $context->buildViolation('Повтор пароля не совпадает')
                    ->addViolation();
            }
        }
    }

    /**
     * Проверка на совпадение нового пароля и старого
     *
     * @param mixed $value
     * @param ExecutionContextInterface $context
     * @param mixed $payload
     *
     * @return void
     */
    public static function validateNewPassword(mixed $value, ExecutionContextInterface $context, mixed $payload): void
    {
        $object = $context->getObject();
        if ($object) {
            if ($object->password === $object->oldPassword) {
                $context->buildViolation('Новый пароль не должен совпадать со старым')
                    ->addViolation();
            }
        }
    }

    /**
     * Проверка пароля
     *
     * @param mixed $value
     * @param ExecutionContextInterface $context
     * @param mixed $payload
     *
     * @return void
     */
    public static function validatePassword(mixed $value, ExecutionContextInterface $context, mixed $payload): void
    {
        $reg = '/(?=^.{8,}$)((?=.*\d)|(?=.*\W+))(?![.\n])(?=.*[A-Z])(?=.*[a-z]).*$/';

        $object = $context->getObject();

        if ($object) {
            if (!preg_match($reg, $object->password)) {
                $context->buildViolation('Пароль должен содержать строчные и прописные латинские буквы, цифры, спецсимволы. Минимум 8 символов')
                    ->addViolation();
            }
        }
    }
}