<?php

namespace App\Service\Send\Classes\Code;

use App\Service\Send\Classes\CodeSendService;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;

#[AsAlias(id: 'send.code.password', public: true)]
class PasswordCodeSendService extends CodeSendService
{
    public function getSubject(): string
    {
        return 'Код восстановления пароля';
    }

    public function getBody(): string
    {
        return <<<HTML
                    <div>Уважаемый {surname} {name} {patronymic}</div>
                    <div>Ваш код для восстановления пароля: <span id="code">{code}</span></div>
                    <div>Время действия кода: {time}</div>
                HTML;
    }

}