<?php

namespace App\Service\Response\Classes;

use App\Entity\Quest;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Serializer\Annotation\Groups;

#[AsAlias(id: 'response.quests', public: true)]
class QuestsResponse extends Response
{
    /**
     * @var Quest[]
     */
    #[Groups(["data"])]
    public array $data;

    /**
     * @param Quest[] $questList
     *
     * @return $this
     */
    public function setData(array $questList): self
    {
        $this->data = $questList;

        return $this;
    }

    public function getGroups(): array
    {
        return ['card'];
    }
}