<?php

namespace App\Service\Response\Classes;

use App\Entity\Quest;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Serializer\Annotation\Groups;

#[AsAlias(id: 'response.quest', public: true)]
class QuestResponse extends Response
{
    /**
     * @var Quest
     */
    #[Groups(["data"])]
    public Quest $data;

    /**
     * @param Quest $quest
     *
     * @return $this
     */
    public function setData(Quest $quest): self
    {
        $this->data = $quest;

        return $this;
    }

    public function getGroups(): array
    {
        return ['detail'];
    }
}