<?php

namespace App\Service\Dto\Classes;

use App\Service\Dto\BaseDto;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Validator\Constraints as Assert;

#[AsAlias(id: 'dto.register.code', public: true)]
class RegisterCodeDto extends BaseDto
{
    #[Assert\NotBlank(
        message: 'Не получен код подтверждения.',
    )]
    #[Assert\Regex(
        pattern: '/^\d{6}$/i',
        message: 'Неверный формат кода'
    )]
    public ?string $code = null;
}