<?php

namespace App\Service\Dto\Classes;

use App\Service\Dto\BaseDto;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Validator\Constraints as Assert;

#[AsAlias(id: 'dto.image', public: true)]
class ImageDto extends BaseDto
{
    #[Assert\NotBlank(
        message: 'Не передано название файла.',
    )]
    public string $name;

    #[Assert\NotBlank(
        message: 'Не передан файл.',
    )]
    #[Assert\Regex(
        pattern: '/^data:([a-z0-9][a-z0-9\!\#\$\&\-\^\_\+\.]{0,126}\/[a-z0-9][a-z0-9\!\#\$\&\-\^\_\+\.]{0,126}(;[a-z0-9\-]+\=[a-z0-9\-]+)?)?(;base64)?,([a-z0-9\!\$\&\\\'\,\(\)\*\+\,\;\=\-\.\_\~\:\@\/\?\%\s]*\s*$)/i',
        message: 'Неверный формат файла'
    )]
    public string $data;
}