<?php

namespace App\Service\Action\Classes;

use App\Entity\Quest;
use App\Redis\Redis;
use App\Redis\RedisFilter;
use App\Service\Action\UserBaseActionService;
use App\Service\Dto\DtoServiceInterface;
use App\Service\Response\ResponseServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.filter.set', public: true)]
class SetFilter extends UserBaseActionService
{
    #[Required] public function initDto(
        #[Autowire(service: 'dto.filter')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }

    public function runAction(): void
    {
        $dto = $this->getDto();
        if ($this->user->getId() && $dto) {
            $redisFilter = new RedisFilter($this->user->getId());
            $redisFilter->set($dto);
            $this->responseService->addMessage('Фильтр установлен');
        } else {
            $this->responseService->addError('Ошибка сохранения фильтра');
        }
    }

    public function needDto(): bool
    {
        return true;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return false;
    }
}