<?php

namespace App\Service\Action\Classes;

use App\Service\Action\UserBaseActionService;
use App\Service\Send\SendServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.register.send', public: true)]
class SendRegisterCode extends UserBaseActionService
{
    #[Required] public function initSend(
        #[Autowire(service: 'send.code.register')]
        SendServiceInterface $sendService
    ): void
    {
        parent::initSend($sendService);
    }


    /**
     * Отправка кода подтверждения регистрации
     *
     * @return void
     *
     * @throws \JsonException
     */
    public function runAction(): void
    {
        $this->sendService->setUser($this->user);
        $this->sendService->setResponse($this->responseService);
        $this->sendService->send();
    }

    public function customValidate(): bool
    {
        if ($this->user->isConfirm()) {
            $this->responseService->addError('Учетная запись уже подтверждена');
            return false;
        }

        return true;
    }

    public function needDto(): bool
    {
        return false;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return false;
    }
}