<?php

namespace App\Service\Action\Classes;

use App\Entity\User;
use App\Service\Action\BaseActionService;
use App\Service\Dto\Classes\ResetPasswordCodeDto;
use App\Service\Dto\DtoServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.reset.password.code', public: true)]
class ResetPasswordCode extends BaseActionService
{

    public function __construct(
        private UserPasswordHasherInterface $passwordHasher,
    )
    {
    }

    #[Required] public function initDto(
        #[Autowire(service: 'dto.password.code')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }


    public function runAction(): void
    {
        /** @var ResetPasswordCodeDto $dto */
        $dto = $this->getDto();
        /** @var User $userExists */
        $userExists = $this->doctrine->getRepository(User::class)
            ->findOneByUniq($dto->email, $dto->phoneNumber);

        if ($userExists !== null) {
            $currentDate = new \DateTime();
            $code = $dto->code;
            $registerCode = $userExists->getRegisterCode();
            if ($registerCode === null) {
                $this->responseService->addError('Код подтверждения не отправлен');
            } else {
                if ($registerCodeDate = $registerCode->getDate()) {
                    if ($registerCode->getCode() === $code && $currentDate->getTimestamp() < $registerCodeDate->getTimestamp()) {
                        try {
                            $hashedPassword = $this->passwordHasher->hashPassword(
                                $userExists,
                                $dto->password ?: ''
                            );
                            $userExists->setPassword($hashedPassword);
                            $em = $this->doctrine->getManager();
                            $em->persist($userExists);
                            $em->remove($registerCode);
                            $em->flush();
                            $this->responseService->addMessage('Пароль изменен');
                        } catch (\Exception $exception) {
                            $this->responseService->addError('Ошибка изменения пароля');
                        }
                    } else {
                        $this->responseService->addError('Код недействителен');
                    }
                } else {
                    $this->responseService->addError('Код недействителен');
                }
            }
        } else {
            $this->responseService->addError('Пользователь не найден');
        }
    }

    public function needDto(): bool
    {
        return true;
    }
}