<?php

namespace App\Service\Action\Classes;

use App\Entity\Favorite;
use App\Entity\Quest;
use App\Service\Action\UserBaseActionService;
use App\Service\Dto\Classes\IdDto;
use App\Service\Dto\DtoServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.favorite.remove', public: true)]
class RemoveFavorite extends UserBaseActionService
{
    #[Required] public function initDto(
        #[Autowire(service: 'dto.id')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }

    public function runAction(): void
    {
        /** @var IdDto $dto */
        $dto = $this->getDto();
        if ($dto->id && $this->user->getId()) {
            /** @var Quest|null $quest */
            $quest = $this->doctrine->getRepository(Quest::class)->findOneById($dto->id, $this->user->getId());
            if ($quest) {
                $favorite = $this->doctrine->getRepository(Favorite::class)->getByQuest($dto->id, $this->user->getId());
                if ($favorite) {
                    try {
                        $em = $this->doctrine->getManager();
                        $em->remove($favorite);
                        $em->flush();
                        $this->responseService->addMessage('Квест удален из избранного');
                    } catch (\Exception $exception) {
                        $this->responseService->addError('Ошибка удаления из избранного');
                    }
                } else {
                    $this->responseService->addError('Квеста нет в списке избранного');
                }
            } else {
                $this->responseService->addError('Квест не найден');
            }
        } else {
            $this->responseService->addError('ID квеста не получен');
        }
    }

    public function needDto(): bool
    {
        return true;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return true;
    }
}