<?php

namespace App\Service\Action\Classes;

use App\Entity\User;
use App\Service\Action\UserBaseActionService;
use App\Service\Dto\Classes\ChangeProfileDto;
use App\Service\Dto\DtoServiceInterface;
use App\Service\Response\ResponseServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.profile.change', public: true)]
class ChangeProfile extends UserBaseActionService
{
    #[Required] public function initResponse(
        #[Autowire(service: 'response.profile')]
        ResponseServiceInterface $responseService
    ): void
    {
        parent::initResponse($responseService);
    }

    #[Required] public function initDto(
        #[Autowire(service: 'dto.profile.change')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }

    public function runAction(): void
    {
        /** @var ChangeProfileDto $dto */
        $dto = $this->getDto();

        /** @var ?User $userExists */
        $userExists = $this->doctrine->getRepository(User::class)
            ->findOneByUniq($dto->email, $dto->phoneNumber, $this->user->getId());

        if ($userExists !== null) {
            if ($userExists->getEmail() === $dto->email) {
                $this->responseService->addError('Email занят другим пользователем');
            } elseif ($userExists->getPhoneNumber() === $dto->phoneNumber) {
                $this->responseService->addError('Номер телефона занят другим пользователем');
            } else {
                $this->responseService->addError('Email или номер телефона занят другим пользователем');
            }
        } else {
            $changed = false;

            if ($dto->name !== null && $dto->name !== $this->user->getName()) {
                $this->user->setName($dto->name);
                $changed = true;
            }

            if ($dto->surname !== null && $dto->surname !== $this->user->getSurname()) {
                $this->user->setSurname($dto->surname);
                $changed = true;
            }

            if ($dto->patronymic !== null && $dto->patronymic !== $this->user->getPatronymic()) {
                $this->user->setPatronymic($dto->patronymic);
                $changed = true;
            }

            if ($dto->phoneNumber !== null && $dto->phoneNumber !== $this->user->getPhoneNumber()) {
                $this->user->setPhoneNumber($dto->phoneNumber);
                $changed = true;
            }

            if ($dto->email !== null && $dto->email !== $this->user->getEmail()) {
                $this->user->setEmail($dto->email);
                $changed = true;
            }

            if ($changed) {
                try {
                    $em = $this->doctrine->getManager();
                    $em->persist($this->user);
                    $em->flush();
                    $this->responseService->setData($this->user);
                } catch (\Exception $e) {
                    $this->responseService->addError('Ошибка сохранения профиля');
                }
            } else {
                $this->responseService->setData($this->user);
            }
        }
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return false;
    }

    public function needDto(): bool
    {
        return true;
    }
}