<?php

namespace App\Service\Action\Classes;

use App\Entity\Favorite;
use App\Entity\Quest;
use App\Service\Action\UserBaseActionService;
use App\Service\Dto\Classes\IdDto;
use App\Service\Dto\DtoServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.favorite.add', public: true)]
class AddFavorite extends UserBaseActionService
{
    #[Required] public function initDto(
        #[Autowire(service: 'dto.id')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }

    public function runAction(): void
    {
        /** @var IdDto $dto */
        $dto = $this->getDto();
        if ($dto->id && $this->user->getId()) {
            /** @var Quest|null $quest */
            $quest = $this->doctrine->getRepository(Quest::class)->findOneById($dto->id, $this->user->getId());
            if ($quest) {
                $favorite = $this->doctrine->getRepository(Favorite::class)->getByQuest($dto->id, $this->user->getId());
                if ($favorite) {
                    $this->responseService->addError('Квест уже в избранном');
                } else {
                    try {
                        $newFavorite = new Favorite();
                        $newFavorite->setQuest($quest);
                        $newFavorite->setRelatedUser($this->user);
                        $em = $this->doctrine->getManager();
                        $em->persist($newFavorite);
                        $em->flush();
                        $this->responseService->addMessage('Квест добавлен в избранное');
                    } catch (\Exception $exception) {
                        $this->responseService->addError('Ошибка добавления в избранное');
                    }
                }
            } else {
                $this->responseService->addError('Квест не найден');
            }
        } else {
            $this->responseService->addError('ID квеста не получен');
        }
    }

    public function needDto(): bool
    {
        return true;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return true;
    }
}