<?php

namespace App\Service\Action;

use App\Service\Dto\DtoServiceInterface;
use App\Service\Response\ResponseServiceInterface;
use App\Service\Send\SendServiceInterface;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\JsonResponse;

interface ActionServiceInterface
{
    public function getResponse(): JsonResponse;

    public function runAction(): void;

    public function validate(): bool;

    public function customValidate(): bool;

    public function initResponse(ResponseServiceInterface $responseService): void;

    public function initDto(DtoServiceInterface $dtoService): void;

    public function initDoctrine(ManagerRegistry $doctrine): void;

    public function initSend(SendServiceInterface $sendService): void;
}