<?php

namespace App\Scheduler;

use App\Messenger\Objects\QuestsEnd;
use App\Messenger\Objects\QuestsStart;
use Symfony\Component\Scheduler\Attribute\AsSchedule;
use Symfony\Component\Scheduler\RecurringMessage;
use Symfony\Component\Scheduler\Schedule;
use Symfony\Component\Scheduler\ScheduleProviderInterface;

#[AsSchedule(name: 'quests')]
class QuestProvider implements ScheduleProviderInterface
{
    public function getSchedule(): Schedule
    {
        $schedule = new Schedule();

        $schedule->add(
            RecurringMessage::every('1 day', new QuestsStart(), from: '09:00'),
            RecurringMessage::every('1 day', new QuestsEnd(), from: '10:00')
        );

        return $schedule;
    }
}