<?php

namespace App\Repository;

use App\Entity\Favorite;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Favorite>
 */
class FavoriteRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Favorite::class);
    }

    public function findAllByUser(int $userId): array
    {
        return $this->createQueryBuilder('f')
            ->setParameter('user_id', $userId)
            ->leftJoin('f.related_user', 'user')
            ->andWhere('user.id = :user_id')
            ->getQuery()
            ->getResult();
    }

    public function getByQuest(int $questId, int $userId): ?Favorite
    {
        return $this->createQueryBuilder('f')
            ->setParameter('user_id', $userId)
            ->leftJoin('f.related_user', 'user')
            ->andWhere('user.id = :user_id')
            ->setParameter('quest_id', $questId)
            ->leftJoin('f.quest', 'quest')
            ->andWhere('quest.id = :quest_id')
            ->getQuery()
            ->getOneOrNullResult();
    }

    //    /**
    //     * @return Favorite[] Returns an array of Favorite objects
    //     */
    //    public function findByExampleField($value): array
    //    {
    //        return $this->createQueryBuilder('f')
    //            ->andWhere('f.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->orderBy('f.id', 'ASC')
    //            ->setMaxResults(10)
    //            ->getQuery()
    //            ->getResult()
    //        ;
    //    }

    //    public function findOneBySomeField($value): ?Favorite
    //    {
//            return $this->createQueryBuilder('f')
//                ->andWhere('f.exampleField = :val')
//                ->setParameter('val', $value)
//                ->getQuery()
//                ->getOneOrNullResult()
//            ;
    //    }
}
