<?php

namespace App\Messenger\Message;

class SendMessage
{
    public function __construct(
        public ?string $from,
        public ?string $to,
        public ?string $subject,
        public ?string $body,
        public ?string $sendType,
    )
    {
    }

    public function getSendType(): ?string
    {
        return $this->sendType;
    }

    public function setSendType(?string $sendType): self
    {
        $this->sendType = $sendType;

        return $this;
    }

    public function getSubject(): string
    {
        return $this->subject;
    }

    public function setSubject(string $subject): self
    {
        $this->subject = $subject;

        return $this;
    }

    public function getBody(): string
    {
        return $this->body;
    }

    public function setBody(string $body): self
    {
        $this->body = $body;

        return $this;
    }

    public function getFrom(): string
    {
        return $this->from;
    }

    public function setFrom(string $from): self
    {
        $this->from = $from;

        return $this;
    }

    public function getTo(): string
    {
        return $this->to;
    }

    public function setTo(string $to): self
    {
        $this->to = $to;

        return $this;
    }
}