<?php

namespace App\Listeners;

use App\Entity\Appointment;
use App\Entity\Favorite;
use App\Entity\Like;
use App\Entity\Review;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsEntityListener;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Events;

#[AsEntityListener(event: Events::preFlush, method: 'prePersistAppointment', entity: Appointment::class)]
#[AsEntityListener(event: Events::preFlush, method: 'prePersistReview', entity: Review::class)]
#[AsEntityListener(event: Events::preFlush, method: 'prePersistLike', entity: Like::class)]
#[AsEntityListener(event: Events::preFlush, method: 'prePersistFavorite', entity: Favorite::class)]
class DateListener
{
    public function prePersistAppointment(Appointment $appointment, PreFlushEventArgs $args): void
    {
        if (!$appointment->getDate()) {
            $appointment->setDate(new \DateTime());
        }
    }

    public function prePersistReview(Review $review, PreFlushEventArgs $args): void
    {
        if (!$review->getCreateDate()) {
            $review->setCreateDate(new \DateTime());
        }
        $review->setUpdateDate(new \DateTime());
    }

    public function prePersistLike(Like $like, PreFlushEventArgs $args): void
    {
        if (!$like->getDate()) {
            $like->setDate(new \DateTime());
        }
    }

    public function prePersistFavorite(Favorite $favorite, PreFlushEventArgs $args): void
    {
        if (!$favorite->getDate()) {
            $favorite->setDate(new \DateTime());
        }
    }
}