<?php

namespace App\Listeners;

use App\Entity\UserCode;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsEntityListener;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Doctrine\ORM\Events;
use Doctrine\Persistence\ObjectManager;
use Random\RandomException;

#[AsEntityListener(event: Events::preFlush, method: 'prePersist', entity: UserCode::class)]
#[AsEntityListener(event: Events::preUpdate, method: 'preUpdate', entity: UserCode::class)]
class CodeListener
{
    public function prePersist(UserCode $code, PreFlushEventArgs $args): void
    {
        $this->checkCode($code, $args->getObjectManager());
    }

    public function preUpdate(UserCode $code, PreUpdateEventArgs $args): void
    {
        $this->checkCode($code, $args->getObjectManager());
    }

    /**
     * Проверка кода и генерация кода
     *
     * @param UserCode $code
     * @param ObjectManager $om
     *
     * @return void
     *
     * @throws RandomException
     */
    public function checkCode(UserCode $code, ObjectManager $om): void
    {
        $user = $code->getRelatedUser();
        if ($user === null) {
            $om->remove($code);
            $om->flush();
        } else {
            $date = $code->getDate();
            $needNewCode = false;
            if ($date === null) {
                $needNewCode = true;
            } else {
                $currentDate = new \DateTime();
                if ($currentDate->getTimestamp() >= $date->getTimestamp()) {
                    $needNewCode = true;
                }
            }

            if ($needNewCode) {
                $newDate = new \DateTime();
                $newDate->setTimestamp($newDate->getTimestamp() + $_ENV['CODE_TTL'] ?: 300);
                $code->setDate($newDate);
                $code->setCode(sprintf('%06d', random_int(0, 999999)));
            }
        }
    }
}