<?php

namespace App\Entity;

use App\Listeners\UserListener;
use App\Repository\UserHistoryRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

#[ORM\Entity(repositoryClass: UserHistoryRepository::class)]
class UserHistory
{
    public const TYPE_CREATE = 'create';
    public const TYPE_UPDATE = 'update';
    public const TYPE_DELETE = 'delete';
    public const TYPE_RECOVERY = 'recovery';

    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'SEQUENCE')]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'userHistories')]
    #[ORM\JoinColumn(nullable: false)]
    private ?User $related_user = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE)]
    private ?\DateTimeInterface $date = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $field = null;

    #[ORM\Column(length: 255)]
    private ?string $type = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $value = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $old_value = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getRelatedUser(): ?User
    {
        return $this->related_user;
    }

    public function setRelatedUser(?User $related_user): static
    {
        $this->related_user = $related_user;

        return $this;
    }

    #[Groups(['all', 'profile'])]
    public function getDate(): ?\DateTimeInterface
    {
        return $this->date;
    }

    public function setDate(\DateTimeInterface $date): static
    {
        $this->date = $date;

        return $this;
    }

    #[Groups(['all', 'profile'])]
    public function getField(): ?string
    {
        return $this->field;
    }

    public function setField(?string $field): static
    {
        $this->field = $field;

        return $this;
    }

    #[Groups(['all', 'profile'])]
    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(string $type): static
    {
        $this->type = $type;

        return $this;
    }

    #[Groups(['all', 'profile'])]
    public function getValue(): ?string
    {
        return $this->value;
    }

    public function setValue(?string $value): static
    {
        $this->value = $value;

        return $this;
    }

    #[Groups(['all', 'profile'])]
    public function getOldValue(): ?string
    {
        return $this->old_value;
    }

    public function setOldValue(?string $old_value): static
    {
        $this->old_value = $old_value;

        return $this;
    }

    #[Groups(['all', 'profile'])]
    public function getText(): ?string
    {
        $text = '';
        $type = $this->getType();

        switch ($field = $this->getField()) {
            case 'password':
                $text = 'Пароль изменен';
                break;
            case 'image':
                switch ($type) {
                    case self::TYPE_CREATE:
                        $text = 'Изображение загружено';
                        break;
                    case self::TYPE_UPDATE:
                        $text = 'Изображение обновлено';
                        break;
                    case self::TYPE_DELETE:
                        $text = 'Изображение удалено';
                        break;
                }
                break;
            case 'confirm':
                switch ($type) {
                    case self::TYPE_CREATE:
                        $text = 'Почта подтверждена';
                        break;
                    case self::TYPE_DELETE:
                        $text = 'Подтверждение почты сброшено';
                        break;
                }
                break;
            case 'user':
                switch ($type) {
                    case self::TYPE_CREATE:
                        $text = 'Пользователь зарегистрирован';
                        break;
                    case self::TYPE_UPDATE:
                        $text = 'Пользователь обновлен';
                        break;
                    case self::TYPE_RECOVERY:
                        $text = 'Пользователь восстановлен';
                        break;
                    case self::TYPE_DELETE:
                        $text = 'Пользователь удален';
                        break;
                }
                break;
            default:
                if (isset(UserListener::HISTORY_FIELDS[$field])) {
                    switch ($type) {
                        case self::TYPE_CREATE:
                            $text = 'Поле "' . UserListener::HISTORY_FIELDS[$field] . '" заполнено';
                            break;
                        case self::TYPE_UPDATE:
                            $text = 'Поле "' . UserListener::HISTORY_FIELDS[$field] . '" обновлено';
                            break;
                        case self::TYPE_DELETE:
                            $text = 'Поле "' . UserListener::HISTORY_FIELDS[$field] . '" удалено ';
                            break;
                    }
                }
                break;
        }

        $time = '';
        if ($date = $this->getDate()) {
            $time = $date->format('d.m.Y H:i:s') . ' - ';
        }

        return $time .  $text;
    }
}
