<?php

namespace App\DataFixtures;

use App\Entity\User;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Bundle\FixturesBundle\FixtureGroupInterface;
use Doctrine\Persistence\ObjectManager;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;

class UserFixture extends Fixture implements FixtureGroupInterface
{
    public const EMAIL = 'test@test.test';
    public const PASSWORD = '123456';

    public function __construct(
        private UserPasswordHasherInterface $passwordHasher,
    )
    {
    }

    public function load(ObjectManager $manager): void
    {
        $user = new User();
        $user->setName('Тест');
        $user->setSurname('Тестов');
        $user->setEmail(self::EMAIL);
        $passwordHash = $this->passwordHasher->hashPassword($user, self::PASSWORD);
        $user->setPassword($passwordHash);
        $user->setConfirm(true);
        $user->setDeleted(false);
        $manager->persist($user);

        $manager->flush();
    }

    public static function getGroups(): array
    {
        return ['test'];
    }
}
