<?php

namespace App\DataFixtures;

use App\Entity\Theme;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Bundle\FixturesBundle\FixtureGroupInterface;
use Doctrine\Persistence\ObjectManager;

class ThemesFixture extends Fixture implements FixtureGroupInterface
{
    public function load(ObjectManager $manager): void
    {
        $data = [
            'Тайное письмо',
            'Кроссворд',
            'Спрятанная подсказка',
            'Викторина',
            'Лабиринт',
            'Загадка',
            'Ребус',
            'Пазл'
        ];

        foreach ($data as $value) {
            $theme = new Theme();
            $theme->setName($value);
            $theme->setDate(new \DateTime());
            $manager->persist($theme);
        }


        $manager->flush();
    }

    public static function getGroups(): array
    {
        return ['main', 'test'];
    }
}
