<?php

namespace App\DataFixtures;

use App\Entity\Genre;
use App\Entity\Quest;
use App\Entity\Tag;
use App\Entity\Theme;
use DateInterval;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Bundle\FixturesBundle\FixtureGroupInterface;
use Doctrine\Persistence\ObjectManager;

class QuestFixture extends Fixture implements FixtureGroupInterface
{
    public function load(ObjectManager $manager): void
    {
        $quest = new Quest();
        $quest->setName('Тестовый квест');
        $quest->setShortDescription('Краткое описание тестового квеста');
        $quest->setFullDescription('Полное описание тестового квеста');
        $quest->setMaxAppointments(6);
        $quest->setDate((new \DateTime())->add(new DateInterval('P10D')));
        $quest->setFinalDate((new \DateTime())->add(new DateInterval('P5D')));

        $genreManager = $manager->getRepository(Genre::class);
        $genres = $genreManager->findAll();
        if (!empty($genres)) {
            $quest->setGenre(reset($genres));
        }

        $themeManager = $manager->getRepository(Theme::class);
        $themes = $themeManager->findAll();
        if (!empty($themes)) {
            $quest->setTheme(reset($themes));
        }

        $tagManager = $manager->getRepository(Tag::class);
        $tags = $tagManager->findAll();
        if (!empty($tags)) {
            foreach ($tags as $tag) {
                $quest->addTag($tag);
            }
        }

        $manager->persist($quest);
        $manager->flush();
    }

    public static function getGroups(): array
    {
        return ['test'];
    }
}