<?php

namespace App\Controller;

use App\Service\Action\ActionServiceInterface;
use App\Service\Dto\Classes\CreateReviewDto;
use App\Service\Dto\Classes\FilterDto;
use App\Service\Dto\Classes\IdDto;
use App\Service\Dto\Classes\PageDto;
use App\Service\Dto\Classes\UpdateReviewDto;
use App\Service\Response\Classes\FilterParamsResponse;
use App\Service\Response\Classes\FilterResponse;
use App\Service\Response\Classes\QuestResponse;
use App\Service\Response\Classes\QuestsPagedResponse;
use App\Service\Response\Classes\QuestsResponse;
use App\Service\Response\Classes\Response;
use Nelmio\ApiDocBundle\Annotation\Model;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use OpenApi\Attributes as OA;

#[Route('/api', name: 'api_')]
#[OA\Tag(name: 'Квесты')]
class QuestController extends AbstractController
{
    #[Route('/quests', name: 'quests', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: PageDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: QuestsPagedResponse::class, groups: ["message", "data", "card", "pagination"])
        )
    )]
    public function quests(
        #[Autowire(service: 'action.quests')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/quest', name: 'quest', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: IdDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: QuestResponse::class, groups: ["message", "data", "detail"])
        )
    )]
    public function quest(
        #[Autowire(service: 'action.quest')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/filter/set', name: 'filter_set', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: FilterDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function setFilter(
        #[Autowire(service: 'action.filter.set')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/filter/get', name: 'filter_get', methods: ['GET'])]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: FilterResponse::class, groups: ["message", "data"])
        )
    )]
    public function getFilter(
        #[Autowire(service: 'action.filter.get')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/filter/params', name: 'filter_params', methods: ['GET'])]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: FilterParamsResponse::class, groups: ["message", "data", "filter"])
        )
    )]
    public function getFilterParams(
        #[Autowire(service: 'action.filter.params')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/quest/subscribe', name: 'quest_subscribe', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: IdDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function subscribe(
        #[Autowire(service: 'action.quest.subscribe')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/quest/unsubscribe', name: 'quest_unsubscribe', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: IdDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function unsubscribe(
        #[Autowire(service: 'action.quest.unsubscribe')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/quest/review/create', name: 'quest_review_create', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: CreateReviewDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function createReview(
        #[Autowire(service: 'action.quest.review.create')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/quest/review/update', name: 'quest_review_update', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: UpdateReviewDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function updateReview(
        #[Autowire(service: 'action.quest.review.update')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/quest/review/delete', name: 'quest_review_delete', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: IdDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function deleteReview(
        #[Autowire(service: 'action.quest.review.delete')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/quest/review/like', name: 'quest_review_like', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: IdDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function likeReview(
        #[Autowire(service: 'action.quest.review.like')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/quest/review/unlike', name: 'quest_review_unlike', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: IdDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function unlikeReview(
        #[Autowire(service: 'action.quest.review.unlike')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/quest/favorite/add', name: 'quest_favorite_add', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: IdDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function addFavorite(
        #[Autowire(service: 'action.favorite.add')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/quest/favorite/remove', name: 'quest_favorite_remove', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: IdDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function removeFavorite(
        #[Autowire(service: 'action.favorite.remove')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }
}