<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20240624101121 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE SEQUENCE genre_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE tag_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE theme_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE TABLE genre (id INT NOT NULL, name VARCHAR(255) NOT NULL, date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE tag (id INT NOT NULL, name VARCHAR(255) NOT NULL, date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE tag_quest (tag_id INT NOT NULL, quest_id INT NOT NULL, PRIMARY KEY(tag_id, quest_id))');
        $this->addSql('CREATE INDEX IDX_61FBE111BAD26311 ON tag_quest (tag_id)');
        $this->addSql('CREATE INDEX IDX_61FBE111209E9EF4 ON tag_quest (quest_id)');
        $this->addSql('CREATE TABLE theme (id INT NOT NULL, name VARCHAR(255) NOT NULL, date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('ALTER TABLE tag_quest ADD CONSTRAINT FK_61FBE111BAD26311 FOREIGN KEY (tag_id) REFERENCES tag (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE tag_quest ADD CONSTRAINT FK_61FBE111209E9EF4 FOREIGN KEY (quest_id) REFERENCES quest (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE quest ADD theme_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE quest ADD genre_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE quest ADD CONSTRAINT FK_4317F81759027487 FOREIGN KEY (theme_id) REFERENCES theme (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE quest ADD CONSTRAINT FK_4317F8174296D31F FOREIGN KEY (genre_id) REFERENCES genre (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('CREATE INDEX IDX_4317F81759027487 ON quest (theme_id)');
        $this->addSql('CREATE INDEX IDX_4317F8174296D31F ON quest (genre_id)');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE SCHEMA public');
        $this->addSql('ALTER TABLE quest DROP CONSTRAINT FK_4317F8174296D31F');
        $this->addSql('ALTER TABLE quest DROP CONSTRAINT FK_4317F81759027487');
        $this->addSql('DROP SEQUENCE genre_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE tag_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE theme_id_seq CASCADE');
        $this->addSql('ALTER TABLE tag_quest DROP CONSTRAINT FK_61FBE111BAD26311');
        $this->addSql('ALTER TABLE tag_quest DROP CONSTRAINT FK_61FBE111209E9EF4');
        $this->addSql('DROP TABLE genre');
        $this->addSql('DROP TABLE tag');
        $this->addSql('DROP TABLE tag_quest');
        $this->addSql('DROP TABLE theme');
        $this->addSql('DROP INDEX IDX_4317F81759027487');
        $this->addSql('DROP INDEX IDX_4317F8174296D31F');
        $this->addSql('ALTER TABLE quest DROP theme_id');
        $this->addSql('ALTER TABLE quest DROP genre_id');
    }
}
