<?php

namespace App\Service\Dto\Classes;

use App\Service\Dto\BaseDto;
use App\Validators\PasswordValidator;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Validator\Constraints as Assert;

#[Assert\Callback([PasswordValidator::class, 'validateRepeatPassword'])]
#[Assert\Callback([PasswordValidator::class, 'validateNewPassword'])]
#[Assert\Callback([PasswordValidator::class, 'validatePassword'])]
#[AsAlias(id: 'dto.password.change', public: true)]
class ChangePasswordDto extends BaseDto
{
    #[Assert\NotBlank(
        message: 'Не получен текущий пароль.',
    )]
    public ?string $oldPassword = null;

    #[Assert\NotBlank(
        message: 'Не получен новый пароль.',
    )]
    public ?string $password = null;

    #[Assert\NotBlank(
        message: 'Не получен повтор нового пароля.',
    )]
    public ?string $repeatPassword = null;
}